import { Pipe, PipeTransform } from '@angular/core';
import { CAPA_ACTION_TYPE } from '../model/capa-action-type-enum';

@Pipe({
  name: 'CapaActionType'
})
export class CapaActionTypePipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case CAPA_ACTION_TYPE.PREVENTIVE:
        return 'PREVENTIVE';
      case CAPA_ACTION_TYPE.CORRECTIVE:
        return 'CORRECTIVE';
      default:
        return '';
    }
  }
}
