import { Pipe, PipeTransform } from '@angular/core';
import { CAPA_REQUEST_LOG_STATUS } from '../model/capa-request-log-status.enum';

@Pipe({
  name: 'CapaRequestLogStatus'
})
export class CapaRequestLogStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case CAPA_REQUEST_LOG_STATUS.CREATED:
        return 'Created';
      case CAPA_REQUEST_LOG_STATUS.UPDATED:
        return 'Updated';
      case CAPA_REQUEST_LOG_STATUS.DELETED:
        return 'Deleted';
      default:
        return '';
    }
  }

}
