import { Pipe, PipeTransform } from '@angular/core';
import { CAPA_REQUEST_PRIORITY } from '../model/capa-Request-Priority-enum';

@Pipe({
  name: 'CapaRequestPriority'
})
export class CapaRequestPriorityPipe implements PipeTransform {

  transform(value: number | null | undefined): string {
    switch (value) {
      case CAPA_REQUEST_PRIORITY.LOW:
        return 'LOW';
      case CAPA_REQUEST_PRIORITY.MEDIUM:
        return 'MEDIUM';
      case CAPA_REQUEST_PRIORITY.HIGH:
        return 'HIGH';
      case CAPA_REQUEST_PRIORITY.CRITICAL:
        return 'CRITICAL';
      default:
        return '';
    }
  }

}
