import { Pipe, PipeTransform } from '@angular/core';
import { CAPA_REQUEST_STATUS } from '../model/capa-Request-Status-enum';

@Pipe({
  name: 'CapaRequestStatus'
})
export class CapaRequestStatusPipe implements PipeTransform {

  transform(value: number | null | undefined): string {
    switch (value) {
      case CAPA_REQUEST_STATUS.OPEN:
        return 'OPEN';
      case CAPA_REQUEST_STATUS.INPROGRESS:
        return 'INPROGRESS';
      case CAPA_REQUEST_STATUS.CLOSED:
        return 'CLOSED';
      case CAPA_REQUEST_STATUS.REVIEWED:
        return 'REVIEWED';
      case CAPA_REQUEST_STATUS.REJECTED:
        return 'REJECTED';
      default:
        return '';
    }
  }
}
