import { Pipe, PipeTransform } from '@angular/core';
import { CAPA_REVIEW_STATUS } from '../model/capa-review-status-enum';

@Pipe({
  name: 'CapaReviewStatus'
})
export class CapaReviewStatusPipe implements PipeTransform {

  transform(value: CAPA_REVIEW_STATUS): string {
    switch (value) {
      case CAPA_REVIEW_STATUS.APPROVED:
        return 'APPROVED';
      case CAPA_REVIEW_STATUS.REJECTED:
        return 'REJECTED';
      case CAPA_REVIEW_STATUS.NEEDS_REVISION:
        return 'NEEDS_REVISION';
      default:
        return '';
    }
  }

}
