import { Injectable, inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { ComplaintAction } from '../model/complaint-action';
import { CommonError } from '@core/error-handler/common-error';
import { Complaint } from '../model/complaint';

@Injectable({
  providedIn: 'root'
})
export class ComplaintActionService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getComplaintActionsByRequestId(complaintRequestId: string): Observable<ComplaintAction[] | CommonError> {
    const url = `ComplaintAction/${complaintRequestId}`;
    return this.httpClient
      .get<ComplaintAction[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addComplaintAction(setting: ComplaintAction): Observable<ComplaintAction | CommonError> {
    const url = 'ComplaintAction';
    return this.httpClient
      .post<ComplaintAction>(url, setting)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteComplaintAction(id: string): Observable<ComplaintAction | CommonError> {
    const url = `ComplaintAction/${id}`;
    return this.httpClient
      .delete<ComplaintAction>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getUserComplaintActions(): Observable<Complaint[] | CommonError> {
    const url = 'Complaint/assigned';
    return this.httpClient
      .get<Complaint[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateComplaintAction(action: ComplaintAction): Observable<ComplaintAction | CommonError> {
    const url = `ComplaintAction/${action.id}`;
    return this.httpClient
      .put<ComplaintAction>(url, action)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
