import { Component, inject, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { ComplaintComment } from '../../model/complaint-comment';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { ComplaintCommentService } from '../complaint-comment.service';

import { ToastrService } from '@core/services/toastr-service';
import { BaseComponent } from '../../../base.component';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { ActivatedRoute } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { MatIconModule } from '@angular/material/icon';

@Component({
  selector: 'app-complaint-comment-list',
  imports: [
    MatIconModule,
    HasClaimDirective,
    TranslateModule,
    UTCToLocalTime,
  ],
  templateUrl: './complaint-comment-list.component.html',
  styleUrl: './complaint-comment-list.component.scss'
})
export class ComplaintCommentListComponent extends BaseComponent implements OnInit, OnChanges {
  @Input() complaintCommentReaponse: ComplaintComment = {} as ComplaintComment;

  complaintCommentService = inject(ComplaintCommentService);
  commandDialogService = inject(CommonDialogService);
  toastrService = inject(ToastrService);
  route = inject(ActivatedRoute);
  complaintCommentList: ComplaintComment[] = [];

  ngOnInit(): void {
    this.route.parent?.paramMap.subscribe(params => {
      const complaintId = params.get('id') || '';
      if (complaintId) {
        this.getComplaintComments(complaintId);
      }
    });
  }

  getComplaintComments(complaintId: string) {
    this.sub$.sink = this.complaintCommentService.getComplaintCommentsByComplaintId(complaintId).subscribe({
      next: (comments) => {
        const complaintComments = comments as ComplaintComment[];
        if (complaintComments && complaintComments.length > 0) {
          this.complaintCommentList = complaintComments;
        } else {
          this.complaintCommentList = [];
        }
      },
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['complaintCommentReaponse'] && this.complaintCommentReaponse) {
      this.complaintCommentList = [...this.complaintCommentList, this.complaintCommentReaponse];
    }
  }

  deleteComplaintComment(capaActionId: string) {
    this.commandDialogService.deleteConfirmtionDialog(this.translationService.getValue("ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS_COMPLAINT_COMMENT")).subscribe({
      next: (result: boolean) => {
        if (result) {
          this.sub$.sink = this.complaintCommentService.deleteComplaintComment(capaActionId).subscribe({
            next: () => {
              this.toastrService.success(this.translationService.getValue('COMPLAINT_COMMENT_DELETE_SUCCESSFULLY'));
              this.complaintCommentList = this.complaintCommentList.filter(action => action.id !== capaActionId);
            },
          });
        }
      }
    });
  }
}
