import { Injectable } from '@angular/core';
import { inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { ComplaintComment } from '../model/complaint-comment';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root'
})
export class ComplaintCommentService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getComplaintCommentsByComplaintId(complaintRequestId: string): Observable<ComplaintComment[] | CommonError> {
    const url = `ComplaintComment/${complaintRequestId}`;
    return this.httpClient
      .get<ComplaintComment[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addComplaintComment(setting: ComplaintComment): Observable<ComplaintComment | CommonError> {
    const url = 'ComplaintComment';
    return this.httpClient
      .post<ComplaintComment>(url, setting)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteComplaintComment(id: string): Observable<ComplaintComment | CommonError> {
    const url = `ComplaintComment/${id}`;
    return this.httpClient
      .delete<ComplaintComment>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
