import { Component, inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { ComplaintCommentListComponent } from "../complaint-comment-list/complaint-comment-list.component";
import { BaseComponent } from '../../../base.component';
import { MatCardModule } from '@angular/material/card';
import { TextEditorComponent } from '@shared/text-editor/text-editor.component';
import { ComplaintComment } from '../../model/complaint-comment';

import { ToastrService } from '@core/services/toastr-service';
import { ComplaintCommentService } from '../complaint-comment.service';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { TranslateModule } from '@ngx-translate/core';
import { MatIconModule } from '@angular/material/icon';


@Component({
  selector: 'app-manage-complaint-comment',
  imports: [
    MatButtonModule,
    ReactiveFormsModule,
    RouterLink,
    ComplaintCommentListComponent,
    TextEditorComponent,
    MatCardModule,
    HasClaimDirective,
    TranslateModule,
    MatIconModule
  ],
  templateUrl: './manage-complaint-comment.component.html',
  styleUrl: './manage-complaint-comment.component.scss'
})
export class ManageComplaintCommentComponent extends BaseComponent implements OnInit {
  complaintCommentForm: FormGroup;
  fb = inject(FormBuilder);
  route = inject(ActivatedRoute);
  complaintComments: ComplaintComment = {} as ComplaintComment;
  complaintCommentService = inject(ComplaintCommentService);
  toastrService = inject(ToastrService);

  ngOnInit(): void {
    this.creatComplaintCommentForm();

    this.route.parent?.paramMap.subscribe(params => {
      const complaintId = params.get('id') || '';
      if (complaintId) {
        this.complaintCommentForm.get('complaintId')?.setValue(complaintId);
      }
    });
  }

  creatComplaintCommentForm() {
    this.complaintCommentForm = this.fb.group({
      complaintId: [''],
      commentText: ['', [Validators.required]],
    });
  }

  onSubmit() {
    if (!this.complaintCommentForm.valid) {
      this.complaintCommentForm.markAllAsTouched();
      return;
    }

    const formValue = this.complaintCommentForm.getRawValue();

    this.sub$.sink = this.complaintCommentService.addComplaintComment(formValue).subscribe({
      next: (response) => {
        const complaintComment = response as ComplaintComment;
        if (complaintComment) {
          this.complaintComments = complaintComment;
          this.complaintCommentForm.get('commentText')?.setValue('');
          this.toastrService.success(this.translationService.getValue('COMPLAINT_COMMENT_CRETED_SUCCESSFULLY'));
        }
      },
    });
  }
}
