import { Routes } from "@angular/router";
import { ComplaintDetailsComponent } from "./complaint-details/complaint-details.component";
import { AuthGuard } from "@core/security/auth.guard";
import { ComplaintResolver } from "./complaint/complaint.resolver";

export const COMPLAINT_ROUTES: Routes = [
  {
    path: 'types',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_COMPLAINT_TYPES' },
    loadComponent: () => import('./complaint-type/complaint-type-list/complaint-type-list.component').then(
      (c) => c.ComplaintTypeListComponent
    ),
  },
  {
    path: 'manage',
    canMatch: [AuthGuard],
    data: { claimType: 'ADD_COMPLAINT_TYPES' },
    loadComponent: () => import('./complaint/manage-complaint/manage-complaint.component').then(
      (c) => c.ManageComplaintComponent
    ),
  },
  {
    path: 'manage/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'EDIT_COMPLAINT_TYPES' },
    loadComponent: () => import('./complaint/manage-complaint/manage-complaint.component').then(
      (c) => c.ManageComplaintComponent
    ),
    resolve: {
      complaintDetails: ComplaintResolver
    }
  },
  {
    path: 'list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_COMPLAINT' },
    loadComponent: () => import('./complaint/complaint-list/complaint-list.component').then(
      (c) => c.ComplaintListComponent
    ),
  },
  {
    path: 'logs',
    canMatch: [AuthGuard],
    data: { claimType: 'MANAGE_COMPLAINT_LOGS' },
    loadComponent: () => import('./complaint-log-list/complaint-log-list.component').then(
      (c) => c.ComplaintLogListComponent
    ),
  },
  {
    path: 'actions',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_COMPLAINT_ACTIONS' },
    loadComponent: () => import('./complaint-action/my-complaint-list/my-complaint-list').then(
      (c) => c.MyComplaintActionList
    ),
  },
  {
    path: 'details/:id',
    component: ComplaintDetailsComponent,
    children: [
      {
        path: '',
        canMatch: [AuthGuard],
        data: { claimType: 'DETAILS_COMPLAINT' },
        loadComponent: () => import('./complaint/manage-complaint/manage-complaint.component').then(
          (c) => c.ManageComplaintComponent
        ),
        resolve: {
          complaintDetails: ComplaintResolver
        }
      },
      {
        path: 'attachment',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_COMPLAINT_ATTACHMENT', 'ADD_COMPLAINT_ATTACHMENT'] },
        loadComponent: () => import('./complaint-attachment/manage-complaint-attachment/manage-complaint-attachment.component').then(
          (c) => c.ManageComplaintAttachmentComponent
        ),
      },
      {
        path: 'action',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_COMPLAINT_ACTION', 'ADD_COMPLAINT_ACTION'] },
        loadComponent: () => import('./complaint-action/manage-complaint-action/manage-complaint-action.component').then(
          (c) => c.ManageComplaintActionComponent
        ),
      },
      {
        path: 'comment',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_COMPLAINT_COMMENT', 'ADD_COMPLAINT_COMMENT'] },
        loadComponent: () => import('./complaint-comment/manage-complaint-comment/manage-complaint-comment.component').then(
          (c) => c.ManageComplaintCommentComponent
        ),
      },
      {
        path: 'investigation',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_COMPLAINT_INVESTIGATION', 'ADD_COMPLAINT_INVESTIGATION'] },
        loadComponent: () => import('./complaint-investigation/manage-complaint-investigation/manage-complaint-investigation.component').then(
          (c) => c.ManageComplaintInvestigationComponent
        ),
      },
      {
        path: 'root-cause',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_COMPLAINT_ROOT_CAUSE', 'ADD_COMPLAINT_ROOT_CAUSE'] },
        loadComponent: () => import('./complaint-root-cause/manage-complaint-root-cause/manage-complaint-root-cause.component').then(
          (c) => c.ManageComplaintRootCauseComponent
        ),
      },
    ]
  }];
