import { Component, inject, OnInit } from '@angular/core';
import { Router, NavigationEnd, ActivatedRoute } from '@angular/router';
import { MatTabsModule } from '@angular/material/tabs';
import { RouterOutlet } from '@angular/router';
import { BaseComponent } from '../../base.component';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { TranslateModule } from '@ngx-translate/core';
import { HasClaimDirective } from '@shared/has-claim.directive';

@Component({
  selector: 'app-complaint-details',
  standalone: true,
  imports: [
    MatTabsModule,
    RouterOutlet,
    PageHelpTextComponent,
    TranslateModule,
    HasClaimDirective
  ],
  templateUrl: './complaint-details.component.html',
  styleUrls: ['./complaint-details.component.scss']
})
export class ComplaintDetailsComponent extends BaseComponent implements OnInit {
  router = inject(Router);
  route = inject(ActivatedRoute);
  selectedTabIndex = 0;
  complaintId: string | null = null;


  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.complaintId = params.get('id');
    });

    this.setTabIndexFromUrl(this.router.url);

    this.sub$.sink = this.router.events.subscribe((event: any) => {
      if (event instanceof NavigationEnd) {
        this.setTabIndexFromUrl(event.urlAfterRedirects);
      }
    });
  }

  setTabIndexFromUrl(url: string) {
    if (url.includes('attachment')) {
      this.selectedTabIndex = 5;
    } else if (url.includes('investigation')) {
      this.selectedTabIndex = 4;
    } else if (url.includes('root-cause')) {
      this.selectedTabIndex = 3;
    } else if (url.includes('comment')) {
      this.selectedTabIndex = 2;
    } else if (url.includes('action')) {
      this.selectedTabIndex = 1;
    } else if (url.includes('/complaint/details')) {
      this.selectedTabIndex = 0;
    }
  }

  onTabChange(index: number) {
    switch (index) {
      case 0:
        this.router.navigate(['/complaint/details', this.complaintId], { queryParams: { isDetailsMode: true } });
        break;
      case 1:
        this.router.navigate(['/complaint/details', this.complaintId, 'action']);
        break;
      case 2:
        this.router.navigate(['/complaint/details', this.complaintId, 'comment']);
        break;
      case 3:
        this.router.navigate(['/complaint/details', this.complaintId, 'root-cause']);
        break;
      case 4:
        this.router.navigate(['/complaint/details', this.complaintId, 'investigation']);
        break;
      case 5:
        this.router.navigate(['/complaint/details', this.complaintId, 'attachment']);
        break;
    }
  }
}
