import { inject, Injectable } from '@angular/core';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { catchError, Observable } from 'rxjs';
import { ComplaintInvestigation } from '../model/complaint-investigation';
import { HttpClient } from '@angular/common/http';

@Injectable({
  providedIn: 'root'
})
export class ComplaintInvestigationService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getComplaintInvestigationsByComplaintId(complaintRequestId: string): Observable<ComplaintInvestigation[] | CommonError> {
    const url = `ComplaintInvestigation/${complaintRequestId}`;
    return this.httpClient
      .get<ComplaintInvestigation[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addComplaintInvestigation(setting: ComplaintInvestigation): Observable<ComplaintInvestigation> {
    const url = 'ComplaintInvestigation';
    return this.httpClient
      .post<ComplaintInvestigation>(url, setting);
  }

  updateComplaintInvestigation(setting: ComplaintInvestigation): Observable<ComplaintInvestigation | CommonError> {
    const url = `ComplaintInvestigation/${setting.id}`;
    return this.httpClient
      .put<ComplaintInvestigation>(url, setting)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteComplaintInvestigation(id: string): Observable<ComplaintInvestigation | CommonError> {
    const url = `ComplaintInvestigation/${id}`;
    return this.httpClient
      .delete<ComplaintInvestigation>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
