import { inject, Injectable } from '@angular/core';
import { ComplaintResource } from '../model/complaint-resource';
import { Complaint } from '../model/complaint';
import { catchError, Observable } from 'rxjs';
import { HttpClient, HttpParams, HttpResponse } from '@angular/common/http';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';

@Injectable({
  providedIn: 'root'
})
export class ComplaintLogService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getComplaints(
    resource: ComplaintResource
  ): Observable<HttpResponse<Complaint[]>> {
    const url = 'ComplaintLog';
    const customParams = new HttpParams()
      .set('OrderBy', resource.orderBy)
      .set('PageSize', resource.pageSize)
      .set('Skip', resource.skip)
      .set('ComplaintNo', resource.complaintNo)
      .set('Title', resource.title)
      .set('ComplaintToDate', resource.complaintToDate ? resource.complaintToDate.toISOString() : '')
      .set('ComplaintFromDate', resource.complaintFromDate ? resource.complaintFromDate.toISOString() : '')
      .set('ReportedBy', resource.reportedBy)
      .set('AssignedToId', resource.assignedToId)
      .set('ComplaintTypeId', resource.complaintTypeId)
      .set('Priority', resource.priority)
      .set('Status', resource.status)
      .set('LogStatus', resource.logStatus ?? '');
    return this.httpClient.get<Complaint[]>(url, {
      params: customParams,
      observe: 'response'
    });
  }
}
