import { Component, inject, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { ComplaintRootCause } from '../../model/complaint-root-cause';
import { MatTableModule } from '@angular/material/table';
import { BaseComponent } from '../../../base.component';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { ComplaintRootCauseService } from '../complaint-root-cause.service';

import { ToastrService } from '@core/services/toastr-service';
import { MatDialog } from '@angular/material/dialog';
import { ManageComplaintRootCauseComponent } from '../manage-complaint-root-cause/manage-complaint-root-cause.component';
import { ActivatedRoute } from '@angular/router';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { TranslateModule } from '@ngx-translate/core';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-complaint-root-cause-list',
  imports: [
    MatTableModule,
    MatIconModule,
    UTCToLocalTime,
    TranslateModule,
    MatCardModule,
    NgClass,
    MatButtonModule
  ],
  templateUrl: './complaint-root-cause-list.component.html',
  styleUrl: './complaint-root-cause-list.component.scss'
})
export class ComplaintRootCauseListComponent extends BaseComponent implements OnInit, OnChanges {
  @Input() complaintRootCauseResponse: ComplaintRootCause = {} as ComplaintRootCause;

  displayedColumns: string[] = ['action', 'createdBy', 'methodUsed', 'createdDate'];
  commandDialogService = inject(CommonDialogService);
  complaintRootCauseService = inject(ComplaintRootCauseService);
  toastrService = inject(ToastrService);
  complaintRootCauseList: ComplaintRootCause[] = [];
  dialog = inject(MatDialog);
  route = inject(ActivatedRoute);

  ngOnInit(): void {
    this.route.parent?.paramMap.subscribe(params => {
      const complaintId = params.get('id') || '';
      if (complaintId) {
        this.getComplaintRootCauses(complaintId);
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['complaintRootCauseResponse'] && this.complaintRootCauseResponse) {
      this.complaintRootCauseList = [...this.complaintRootCauseList, this.complaintRootCauseResponse];
    }
  }

  getComplaintRootCauses(complaintId: string) {
    this.sub$.sink = this.complaintRootCauseService.getComplaintRootCausesById(complaintId).subscribe({
      next: (response) => {
        const complaintRootCauseResponse = response as ComplaintRootCause[];
        if (complaintRootCauseResponse) {
          this.complaintRootCauseList = complaintRootCauseResponse;
        }
      },
    });
  }
  viewComplaintRootCause(complaintRootCause: ComplaintRootCause) {
    this.dialog.open(ManageComplaintRootCauseComponent, {
      maxWidth: '50vw',
      width: '100%',
      data: { complaintRootCause, isViewOnly: true },
      panelClass: 'full-width-dialog'
    });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.complaintRootCauseList.indexOf(row);
  }
}
