import { Injectable, inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable, catchError } from 'rxjs';
import { ComplaintRootCause } from '../model/complaint-root-cause';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';


@Injectable({
  providedIn: 'root'
})
export class ComplaintRootCauseService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getComplaintRootCausesById(rootCauseId: string): Observable<ComplaintRootCause[] | CommonError> {
    const url = `ComplaintRootCause/${rootCauseId}`;
    return this.httpClient
      .get<ComplaintRootCause[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  createComplaintRootCause(complaintRootCause: ComplaintRootCause): Observable<ComplaintRootCause> {
    const url = 'ComplaintRootCause';
    return this.httpClient
      .post<ComplaintRootCause>(url, complaintRootCause);

  }
}
