import { Injectable, inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable, catchError } from 'rxjs';
import { ComplaintType } from '../model/complaint-type';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root'
})
export class ComplaintTypeService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getComplaintTypes(): Observable<ComplaintType[]> {
    const url = 'ComplaintType';
    return this.httpClient
      .get<ComplaintType[]>(url);

  }

  addComplaintType(type: ComplaintType): Observable<ComplaintType | CommonError> {
    const url = 'ComplaintType';
    return this.httpClient
      .post<ComplaintType>(url, type)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateComplaintType(type: ComplaintType): Observable<ComplaintType | CommonError> {
    const url = `ComplaintType/${type.id}`;
    return this.httpClient
      .put<ComplaintType>(url, type)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteComplaintType(typeId: string): Observable<void | CommonError> {
    const url = `ComplaintType/${typeId}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
