import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { Complaint } from '../model/complaint';
import { ComplaintService } from './complaint.service';
import { inject } from '@angular/core';
import { Observable, of } from 'rxjs';

export const ComplaintResolver: ResolveFn<Complaint | undefined> = (route: ActivatedRouteSnapshot) => {
  const complaintService = inject(ComplaintService);
  const complaintId = route.paramMap.get('id');

  if (complaintId !== null) {
    return complaintService.getComplaintById(complaintId) as Observable<Complaint>;
  } return;
};
