import { Pipe, PipeTransform } from '@angular/core';
import { COMPLAINT_ACTION_STATUS } from '../model/complaint-action-status-enum';

@Pipe({
    name: 'ComplaintActionStatus'
})
export class ComplaintActionStatusPipe implements PipeTransform {

    transform(value: number): string {
        switch (value) {
            case COMPLAINT_ACTION_STATUS.OPEN:
                return 'OPEN';
            case COMPLAINT_ACTION_STATUS.IN_PROGRESS:
                return 'IN_PROGRESS';
            case COMPLAINT_ACTION_STATUS.RESOLVED:
                return 'RESOLVED';
            case COMPLAINT_ACTION_STATUS.CLOSED:
                return 'CLOSED';
            case COMPLAINT_ACTION_STATUS.ESCALATED:
                return 'ESCALATED';
            case COMPLAINT_ACTION_STATUS.REJECTED:
                return 'REJECTED';
            case COMPLAINT_ACTION_STATUS.PENDING:
                return 'PENDING';
            default:
                return '';
        }
    }
}