import { Pipe, PipeTransform } from '@angular/core';
import { COMPLAINT_LOG_STATUS } from '../model/complaint-log-status.enum';

@Pipe({
  name: 'ComplaintLogStatus'
})
export class ComplaintLogStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case COMPLAINT_LOG_STATUS.CREATED:
        return 'CREATED';
      case COMPLAINT_LOG_STATUS.UPDATED:
        return 'UPDATED';
      case COMPLAINT_LOG_STATUS.DELETED:
        return 'DELETED';
      default:
        return '';
    }
  }
}
