import { Pipe, PipeTransform } from '@angular/core';
import { COMPLAINT_PRIORITY } from '../model/complaint-priority.enum';

@Pipe({
  name: 'ComplaintPriority'
})
export class ComplaintPriorityPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case COMPLAINT_PRIORITY.LOW:
        return 'LOW';
      case COMPLAINT_PRIORITY.MEDIUM:
        return 'MEDIUM';
      case COMPLAINT_PRIORITY.HIGH:
        return 'HIGH';
      case COMPLAINT_PRIORITY.CRITICAL:
        return 'CRITICAL';
      default:
        return '';
    }
  }
}