import { Pipe, PipeTransform } from '@angular/core';
import { COMPLAINT_REPORTED_BY } from '../model/complaint-reported-by.enum';

@Pipe({
  name: 'ComplaintReportedBy'
})
export class ComplaintReportedByPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case COMPLAINT_REPORTED_BY.USER:
        return 'USER';
      case COMPLAINT_REPORTED_BY.CUSTOMER:
        return 'CUSTOMER';
      case COMPLAINT_REPORTED_BY.STAFF:
        return 'STAFF';
      default:
        return '';
    }
  }
}
