import { Pipe, PipeTransform } from '@angular/core';
import { COMPLAINT_STATUS } from '../model/complaint-status.enum';

@Pipe({
  name: 'ComplaintStatus'
})
export class ComplaintStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case COMPLAINT_STATUS.OPEN:
        return 'OPEN';
      case COMPLAINT_STATUS.IN_PROGRESS:
        return 'INPROGRESS';
      case COMPLAINT_STATUS.RESOLVED:
        return 'RESOLVED';
      case COMPLAINT_STATUS.CLOSED:
        return 'CLOSED';
      case COMPLAINT_STATUS.ESCALATED:
        return 'ESCALATED';
      case COMPLAINT_STATUS.REJECTED:
        return 'REJECTED';
      case COMPLAINT_STATUS.PENDING:
        return 'PENDING';
      default:
        return 'UNKNOWN';
    }
  }
}
