import { NgClass } from '@angular/common';
import { Component, Inject } from '@angular/core';
import { ReactiveFormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MAT_DIALOG_DATA, MatDialogModule, MatDialogRef } from '@angular/material/dialog';
import { MatIconModule } from '@angular/material/icon';
import { Router, RouterModule } from '@angular/router';
import { AuditNotification } from '@core/domain-classes/audit-notification';
import { TranslateModule } from '@ngx-translate/core';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { AUDIT_STATUS } from '../../audit-template/models/audit-status';
import { AuditStatusPipe } from '../../audit/audit-status.pipe';

@Component({
  selector: 'app-audit-review-notification',
  imports: [
    MatDialogModule,
    TranslateModule,
    ReactiveFormsModule,
    RouterModule,
    AuditStatusPipe,
    MatIconModule,
    MatButtonModule,
    UTCToLocalTime,
    NgClass
],
  templateUrl: './audit-review-notification.component.html',
  styleUrl: './audit-review-notification.component.scss'
})
export class AuditReviewNotificationComponent {
  AUDIT_STATUS = AUDIT_STATUS;
  /**
   *
   */
  constructor(
    private dialogRef: MatDialogRef<AuditReviewNotificationComponent>,
    @Inject(MAT_DIALOG_DATA) public data: AuditNotification[],
    private router: Router
  ) {

  }
  onDetailClick(auditId: string) {
    this.router.navigate(['/audit/report', auditId]);
    this.closeDialog();
  }

  closeDialog() {
    this.dialogRef.close();
  }

}
