import { AUDIT_STATUS } from "../../audit-template/models/audit-status";
import { AuditTemplate } from "../../audit-template/models/audit-template";
import { CapaRequest } from "../../capa/model/capa-request";
import { NonConformance } from "../../non-conformance/model/non-conformance";
import { AuditReviewer } from "./audit-reviewer";
import { AuditReviewComment } from "./audit-review-comments";
import { QUESTION_TYPE } from "../../audit-template/models/question-type";
import { AuditResponseAttachment } from "../../audit/models/audit-response-attachments";

export interface Audit {
  id?: string;
  auditorId?: string;
  title?: string;
  auditTemplateId?: string;
  auditTemplate: AuditTemplate;
  departmentName?: string;
  auditorName?: string;
  status?: number;
  totalScore?: number;
  effectiveScore?: number;
  capaRequests?: CapaRequest[];
  nonConformances?: NonConformance[];
  auditNumber?: string;
  auditQuestionResponses?: AuditQuestionResponse[];
  auditReviewers?: AuditReviewer[];
  auditReviewComments?: AuditReviewComment[];
  createdDate?: Date;
}

export interface StartAudit {
  id?: string;
  auditorId?: string;
  auditTemplateId?: string;
  status?: AUDIT_STATUS;
  title?: string;
}

export interface AuditQuestionResponse {
  question: string;
  questionId: string;
  response: string;
  inputType: QUESTION_TYPE;
  effectiveScore?: number;
  totalScore?: number;
  auditResponseAttachments?: AuditResponseAttachment[];
}

export interface SubmitAudit {
  id?: string;
  reviewerId?: string;
  auditId?: string;
  comments?: string;
  status?: AUDIT_STATUS;
}

export interface AuditReview {
  auditId: string;
  status?: AUDIT_STATUS;
  comments?: string;
}
