import { Client } from './client';
import { DocumentRolePermission } from './document-role-permission';
import { DocumentUserPermission } from './document-user-permission';
import { DocumentMetaData } from './document-meta-data';
import { DocumentVersion } from './documentVersion';
import { WorkflowShortDetail } from './workflow-short-detail';
import { RETENTION_ACTION_ENUM } from './retention_action_enum';

export interface DocumentInfo {
  id?: string;
  name: string;
  url?: string;
  description?: string;
  createdDate: Date;
  createdBy: string;
  categoryId?: string;
  documentStatusId?: string;
  documentStatus?: string;
  clientId?: string;
  client?: Client;
  storageSettingId?: string;
  categoryName?: string;
  documentSource?: string;
  extension?: string;
  isVersion?: boolean;
  viewerType?: string;
  expiredDate?: Date;
  isAllowDownload?: boolean;
  documentVersions?: DocumentVersion[];
  documentMetaDatas?: DocumentMetaData[];
  documentUserPermissions?: DocumentUserPermission[];
  documentRolePermissions?: DocumentRolePermission[];
  file?: File;
  isAddedPageIndxing?: boolean;
  isIndexable?: boolean
  isMoreThan15MinutesFromLocal?: boolean;
  isSignatureExists?: boolean;
  signBy?: string;
  signByDate?: Date;
  documentNumber: string;
  workflowsDetail?: WorkflowShortDetail[];
  comment?: string;
  isChunk?: boolean;
  isAssignToMe?: boolean;
  documentVersionId?: string;
  versionNumber?: number;
  commentCount?: number;
  isUnreadComment?: boolean;
  mediaType?: number;
  isShared?: boolean;
  isAssignUser?: boolean;
  retentionPeriodInDays?: number;
  onExpiryAction?: RETENTION_ACTION_ENUM;
  documentContent?: string;
  archiveById?: string;
  archiveName?: string;
}
