import { CourseSessionMedia } from "./course-session-media"
import { EmployeeCourseSessionQuiz } from "./employee-course-session-quiz"


export interface EmployeeCourseSession {
    assignedDate: Date,
    completedDate: Date,
    courseName: string,
    courseSessionId: string,
    employeeCourseSessionQuizzes: EmployeeCourseSessionQuiz[],
    courseSessionMedias: CourseSessionMedia[]
    employeeId: string,
    employeeName: string,
    id: string
    isCompleted: boolean
    sessionDescription: string,
    sessionName: string,
    isPassed: boolean,
    hasQuiz: boolean,
}

export interface EmployeeCourse {
    id: string,
    courseName: string,
    completedPercentage: number,
    courseDescription: string,
    link: string,
    status: number;
    employeeName: string;
    completedDate: Date;
    courseSessions: [
        {
            id: string,
            title: string,
            description: string,
            courseId: string,
            courseName: string,
            completedPercentage: number,
            hasQuiz: boolean,
        }
    ]
}

