export interface QuizQuestion {
    id: string,
    courseSessionQuizId: string,
    questionText: string,
    orderNo: number;
    quizQuestionOptions: QuizQuestionOption[]
}

export interface QuizQuestionOption {
    id: string,
    optionText: string,
    quizQuestionId: string,
    isCorrect: boolean,
}
// employee assign time 
export interface QuizFormResponse {
    id?: string,
    courseSessionId: string,
    link?: string,
    employeeCourseSessionQuizQuestions: QuizFormResponseQuestion[]
}

export interface QuizFormResponseQuestion {
    questionId: string,
    selectedOptions: QuizFormSelectedOptions[]
}

export interface QuizFormSelectedOptions {
    optionId: string,
    optionText: string,
    isSelected?: boolean
}

export interface QuizResponse {
    courseSessionId: string,
    link?: string,
    employeeCourseSessionQuizQuestions: QuizResponseQuestionOptions[]
}

export interface QuizResponseQuestionOptions {
    questionId: string,
    selectedOptionIds: string[]
}