import { MenuInfo } from './menu-info';

export const ROUTES: MenuInfo[] = [
  {
    path: 'dashboard',
    title: 'DASHBOARD',
    icon: 'dashboard',
    class: '',
    submenu: [],
    hasClaims: ['VIEW_DASHBOARD'],
  },
  {
    path: '',
    title: 'AUDIT',
    icon: 'assignment',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_AUDIT',
      'VIEW_AUDIT_FOR_REVIEW',
      'VIEW_AUDIT_TEMPLATE',
      'VIEW_DEPARTMENT',
    ],
    submenu: [
      {
        path: 'audit/audit-list',
        title: 'AUDIT_LIST',
        icon: 'list_alt',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_AUDIT'],
      },
      {
        path: 'audit/audit-for-review',
        title: 'AUDIT_FOR_REVIEW',
        icon: 'pending_actions',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_AUDIT_FOR_REVIEW'],
      },
      {
        path: 'audit/audit-template',
        title: 'MANAGE_AUDIT_TEMPLATE',
        icon: 'file_copy',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_AUDIT_TEMPLATE'],
      },
      {
        path: 'department',
        title: 'DEPARTMENT',
        icon: 'domain',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_DEPARTMENT'],
      },
      {
        path: 'audit/logs',
        title: 'AUDIT_LOGS',
        icon: 'history',
        class: 'ml-menu',
        submenu: [],
        hasClaims: [],
      },
    ],
  },
  {
    path: '',
    title: 'CAPA',
    icon: 'shield',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_CAPA_REQUEST',
      'VIEW_CAPA_ROOT_CAUSE_METHODOLOGY',
      'MANAGE_CAPA_REQUEST_LOGS',
      'VIEW_CAPA_ACTIONS',
    ],
    submenu: [
      {
        path: 'capa/requests',
        title: 'CAPA_REQUEST',
        icon: 'assignment_turned_in',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_CAPA_REQUEST'],
      },
      {
        path: 'capa/root-cause-methodology',
        title: 'ROOT_CAUSE_METHODOLOGY',
        icon: 'psychology',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_CAPA_ROOT_CAUSE_METHODOLOGY'],
      },
      {
        path: 'capa/request/logs',
        title: 'CAPA_REQUEST_LOGS',
        icon: 'article',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_CAPA_REQUEST_LOGS'],
      },
      {
        path: 'capa/actions',
        title: 'MY_CAPA_ACTIONS',
        icon: 'build',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_CAPA_ACTIONS'],
      },
    ],
  },
  {
    path: '',
    title: 'NON_CONFORMANCE',
    icon: 'error',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_NON_CONFORMANCE',
      'ADD_NON_CONFORMANCE',
      'MANAGE_NON_CONFORMANCE_LOGS',
      'VIEW_NON_CONFORMANCE_RESPONSE_TYPE',
    ],
    submenu: [
      {
        path: 'nc/conformances',
        title: 'LIST',
        icon: 'list',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_NON_CONFORMANCE'],
      },
      {
        path: 'nc/conformance/manage',
        title: 'ADD_NEW',
        icon: 'add_circle',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['ADD_NON_CONFORMANCE'],
      },
      {
        path: 'nc/conformance/logs',
        title: 'NON_CONFORMANCE_LOGS',
        icon: 'history',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_NON_CONFORMANCE_LOGS'],
      },
      {
        path: 'nc/conformance/response/type',
        title: 'RESPONSE_TYPE',
        icon: 'style',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_NON_CONFORMANCE_RESPONSE_TYPE'],
      },
    ],
  },
  {
    path: '',
    title: 'COMPLAINT',
    icon: 'feedback',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_COMPLAINT',
      'ADD_COMPLAINT',
      'VIEW_COMPLAINT_TYPES',
      'MANAGE_COMPLAINT_LOGS',
      'VIEW_COMPLAINT_ACTIONS',
    ],
    submenu: [
      {
        path: 'complaint/list',
        title: 'LIST',
        icon: 'list',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_COMPLAINT'],
      },
      {
        path: 'complaint/manage',
        title: 'ADD_NEW',
        icon: 'add',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['ADD_COMPLAINT'],
      },
      {
        path: 'complaint/types',
        title: 'COMPLAINT_TYPE',
        icon: 'category',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_COMPLAINT_TYPES'],
      },
      {
        path: 'complaint/logs',
        title: 'COMPLAINT_LOGS',
        icon: 'history',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_COMPLAINT_LOGS'],
      },
      {
        path: 'complaint/actions',
        title: 'MY_COMPLAINT',
        icon: 'build',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_COMPLAINT_ACTIONS'],
      },
    ],
  },
  {
    path: '',
    title: 'RISK_MANAGEMENT',
    icon: 'warning',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_RISK_MANAGEMENT',
      'ADD_RISK_MANAGEMENT',
      'VIEW_RISK_CATEGORY',
      'MANAGE_RISK_LOGS',
      'VIEW_RISK_LIST',
    ],
    submenu: [
      {
        path: 'risk/list',
        title: 'LIST',
        icon: 'list',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_RISK_MANAGEMENT'],
      },
      {
        path: 'risk/manage',
        title: 'ADD_NEW',
        icon: 'add',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['ADD_RISK_MANAGEMENT'],
      },
      {
        path: 'risk/categories',
        title: 'RISK_CATEGORY',
        icon: 'category',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_RISK_CATEGORY'],
      },
      {
        path: 'risk/logs',
        title: 'RISK_LOGS',
        icon: 'history',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_RISK_LOGS'],
      },
      {
        path: 'risk/my-risk-list',
        title: 'MY_RISKS',
        icon: '',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_RISK_LIST'],
      }
    ],
  },
  {
    path: '',
    title: 'SUPPLIER',
    icon: 'local_shipping',
    class: 'menu-toggle',
    hasClaims: ['VIEW_SUPPLIER', 'ADD_SUPPLIER'],
    submenu: [
      {
        path: 'supplier/list',
        title: 'LIST',
        icon: 'storefront',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_SUPPLIER'],
      },
      {
        path: 'supplier/manage',
        title: 'ADD_NEW',
        icon: 'add_business',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['ADD_SUPPLIER'],
      },
    ],
  },
  {
    path: '',
    title: 'TRAINING',
    icon: 'school',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_COURSE',
      'VIEW_EMPLOYEE',
      'ASSIGN_COURSE',
      'IMPORT_EMPLOYEE',
      'MANAGE_COURSE_SUMMARY',
      'VIEW_COURSES',
    ],
    submenu: [
      {
        path: 'course/list',
        title: 'COURSE',
        icon: 'book',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_COURSE'],
      },
      {
        path: 'course/my-courses',
        title: 'MY_COURSES',
        icon: 'menu_book',
        class: '',
        hasClaims: ['VIEW_COURSES'],
        submenu: [],
      },
      {
        path: 'course/assign',
        title: 'ASSIGN_COURSE',
        icon: 'assignment_ind',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['ASSIGN_COURSE'],
      },
      {
        path: 'course/summary',
        title: 'COURSE_SUMMARY',
        icon: 'summarize',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_COURSE_SUMMARY'],
      },
    ],
  },
  {
    path: '',
    title: 'DOCUMENT_MANAGEMENT',
    icon: 'article',
    class: 'menu-toggle',
    hasClaims: [],
    submenu: [
      {
        path: '',
        title: 'ASSIGNED_DOCUMENT',
        icon: 'assignment',
        class: 'ml-sub-menu',
        hasClaims: [],
        submenu: [
          {
            path: 'assign/list-view',
            title: 'DOCUMENT_VIEW',
            icon: 'visibility',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: [],
          },
          {
            path: 'assign/folder-view',
            title: 'FOLDER_VIEW',
            icon: 'folder_open',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: [],
          },
        ],
      },
      {
        path: 'documents',
        title: 'ALL_DOCUMENT',
        icon: 'layers',
        class: 'ml-sub-menu',
        hasClaims: ['ALL_VIEW_DOCUMENTS'],
        submenu: [
          {
            path: 'documents/list-view',
            title: 'DOCUMENT_VIEW',
            icon: 'visibility',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: [],
          },
          {
            path: 'documents/folder-view',
            title: 'FOLDER_VIEW',
            icon: 'folder_open',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: [],
          },
        ],
      },
      {
        path: 'categories',
        title: 'DOCUMENT_CATEGORIES',
        icon: 'folder',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_CATEGORIES'],
      },
      {
        path: 'documents/deep-search',
        title: 'DEEP_SEARCH',
        icon: 'search',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['DEEP_SEARCH'],
      },
      {
        path: '',
        title: 'AI_DOCUMENTS',
        icon: 'smart_toy',
        class: 'ml-sub-menu',
        hasClaims: ['VIEW_PROMPT_TEMPLATES', 'AI_DOCUMENT_GENERATOR'],
        submenu: [
          {
            path: 'ai-document-generator',
            title: 'AI_DOCUMENT_GENERATOR',
            icon: 'smart_toy',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: ['AI_DOCUMENT_GENERATOR'],
          },
          {
            path: 'ai-document-generator-list',
            title: 'AI_DOCUMENT_GENERATOR_LIST',
            icon: 'list',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: ['VIEW_AI_DOCUMENT_GENERATOR'],
          },
          {
            path: 'aiprompttemplate',
            title: 'AI_PROMPT_TEMPLATES',
            icon: 'edit',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: ['VIEW_PROMPT_TEMPLATES'],
          },
        ],
      },
      {
        path: 'documents/ocr_content_extractor',
        title: 'OCR_CONTENT_EXTRACTOR',
        icon: 'text_snippet',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['OCR_CONTENT_EXTRACTOR'],
      },
      {
        path: 'bulk-document-upload',
        title: 'BULK_DOCUMENT_UPLOAD',
        icon: 'upload_file',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['BULK_DOCUMENT_UPLOADS'],
      },
      {
        path: 'file-request',
        title: 'FILE_REQUEST_LINK',
        icon: 'add_link',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_FILE_REQUEST'],
      },
      {
        path: 'document-audit-trails',
        title: 'DOCUMENTS_AUDIT_TRAIL',
        icon: 'restore',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_DOCUMENT_AUDIT_TRAIL'],
      },
      {
        path: 'recent-activity',
        title: 'RECENT_ACTIVITY',
        icon: 'refresh',
        class: 'ml-menu',
        submenu: [],
        hasClaims: [],
      },
      {
        path: '',
        title: 'ARCHIVE',
        icon: 'archive',
        class: 'ml-sub-menu',
        hasClaims: [],
        submenu: [
          {
            path: 'archive-documents',
            title: 'DOCUMENTS',
            icon: 'insert_drive_file',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: [],
          },
          {
            path: 'archive-folders',
            title: 'FOLDERS',
            icon: 'folder',
            class: 'ml-menu2',
            submenu: [],
            hasClaims: [],
          },
          {
            path: 'archive-retention-period',
            title: 'ARCHIVE_RETENTION_PERIOD',
            icon: 'access_time',
            class: 'ml-menu',
            submenu: [],
            hasClaims: [],
          },
        ],
      },
      {
        path: 'document-status',
        title: 'DOCUMENT_STATUS',
        icon: 'check_circle',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_DOCUMENT_STATUS'],
      },
    ],
  },
  {
    path: '',
    title: 'WORKFLOWS',
    icon: 'repeat',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_WORKFLOW_SETTINGS',
      'ADD_WORKFLOW_SETTINGS',
      'EDIT_WORKFLOW_SETTINGS',
      'DELETE_WORKFLOW_SETTINGS',
      'WORKFLOWS',
      'WORKFLOW_LOGS',
    ],
    submenu: [
      {
        path: 'workflow-settings',
        title: 'WORKFLOW_SETTINGS',
        icon: 'settings',
        class: 'ml-menu',
        submenu: [],
        hasClaims: [
          'VIEW_WORKFLOW_SETTINGS',
          'ADD_WORKFLOW_SETTINGS',
          'EDIT_WORKFLOW_SETTINGS',
          'DELETE_WORKFLOW_SETTINGS',
        ],
      },
      {
        path: 'workflows',
        title: 'ALL_WORKFLOWS',
        icon: 'playlist_add_check',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['WORKFLOWS'],
      },
      {
        path: 'request_document_through_workflow',
        title: 'REQUEST_DOCUMENT_THROUGH_WORKFLOW',
        icon: 'send',
        class: 'ml-menu2',
        submenu: [],
        hasClaims: [],
      },
      {
        path: 'workflowlogs',
        title: 'WORKFLOW_LOGS',
        icon: 'history',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['WORKFLOW_LOGS'],
      },
    ],
  },
  {
    path: 'current-workflow',
    title: 'ASSIGNED_WORKFLOWS',
    icon: 'call_merge',
    class: '',
    submenu: [],
    hasClaims: ['CURRENT_WORKFLOW'],
  },
  {
    path: 'reminders',
    title: 'REMINDER',
    icon: 'notifications',
    class: '',
    submenu: [],
    hasClaims: ['VIEW_REMINDERS'],
  },
  {
    path: 'client',
    title: 'CLIENTS',
    icon: 'folder_shared',
    class: '',
    submenu: [],
    hasClaims: ['VIEW_CLIENTS'],
  },
  {
    path: '',
    title: 'ACCESS_CONTROL',
    icon: 'security',
    class: 'menu-toggle',
    hasClaims: ['VIEW_ROLES', 'VIEW_USERS', 'ASSIGN_USER_ROLE'],
    submenu: [
      {
        path: 'roles',
        title: 'ROLES',
        icon: 'shield',
        class: '',
        submenu: [],
        hasClaims: ['VIEW_ROLES'],
      },
      {
        path: 'users',
        title: 'USERS',
        icon: 'groups',
        class: '',
        submenu: [],
        hasClaims: ['VIEW_USERS'],
      },
      {
        path: 'roles/users',
        title: 'ROLE_USER',
        icon: 'person_add',
        class: '',
        submenu: [],
        hasClaims: ['ASSIGN_USER_ROLE'],
      },
    ],
  },
  {
    path: '',
    title: 'SETTINGS',
    icon: 'settings',
    class: 'menu-toggle',
    hasClaims: [
      'VIEW_SMTP_SETTINGS',
      'GENERAL_SETTINGS',
      'MANAGE_STORAGE_SETTINGS',
      'MANAGE_COMPANY_SETTINGS',
      'MANAGE_PAGE_HELPER',
      'VIEW_ALLOW_FILE_EXTENSIONS',
    ],
    submenu: [
      {
        path: '/email-smtp',
        title: 'EMAIL_SMTP_SETTINGS',
        icon: 'email',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_SMTP_SETTINGS'],
      },
      {
        path: '/general-settings',
        title: 'GENERAL_SETTINGS',
        icon: 'settings',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['GENERAL_SETTINGS'],
      },
      {
        path: '/storage-settings',
        title: 'STORAGE_SETTINGS',
        icon: 'storage',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_STORAGE_SETTINGS'],
      },
      {
        path: '/page-helper',
        title: 'PAGE_HELPER',
        icon: 'help_outline',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_PAGE_HELPER'],
      },
      {
        path: 'allow-file-extension',
        title: 'ALLOW_FILE_EXTENSIONS',
        icon: 'extension',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_ALLOW_FILE_EXTENSIONS'],
      },
      {
        path: 'company-profile',
        title: 'COMPANY_PROFILE',
        icon: 'business',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['MANAGE_COMPANY_SETTINGS'],
      },
      {
        path: 'document-meta-tag',
        title: 'DOCUMENT_META_TAGS',
        icon: 'label',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_DOCUMENT_META_TAGS'],
      },
    ],
  },
  {
    path: '',
    title: 'LOGS',
    icon: 'view_list',
    class: 'menu-toggle',
    hasClaims: ['VIEW_LOGIN_AUDIT_LOGS', 'VIEW_ERROR_LOGS'],
    submenu: [
      {
        path: 'login-audit',
        title: 'LOGIN_AUDITS',
        icon: 'login',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_LOGIN_AUDIT_LOGS'],
      },
      {
        path: '/logs',
        title: 'ERROR_LOGS',
        icon: 'error_outline',
        class: 'ml-menu',
        submenu: [],
        hasClaims: ['VIEW_ERROR_LOGS'],
      },
    ],
  },
];
