import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../base.component';
import { DashboradService } from './dashboard.service';
import { StatisticsComponent } from './statistics/statistics.component';
import { AuditStatusOverviewChartComponent } from './audit-status-overview-chart/audit-status-overview-chart.component';
import { AuditCountByDepartmentChartComponent } from './audit-count-by-department-chart/audit-count-by-department-chart.component';
import { NonConformanceChartComponent } from './non-conformance-chart/non-conformance-chart.component';
import { CapaCountOverTimeChartComponent } from './capa-count-over-time-chart/capa-count-over-time-chart.component';
import { NcBySeverityLevelChartComponent } from './nc-by-severity-level-chart/nc-by-severity-level-chart.component';
import { DocumentByCategoryChartComponent } from './document-by-category-chart/document-by-category-chart.component';
import { CalenderViewComponent } from './calender-view/calender-view.component';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  standalone: true,
  imports: [
    StatisticsComponent,
    AuditStatusOverviewChartComponent,
    AuditCountByDepartmentChartComponent,
    NonConformanceChartComponent,
    CapaCountOverTimeChartComponent,
    NcBySeverityLevelChartComponent,
    DocumentByCategoryChartComponent,
    CalenderViewComponent
  ]
})
export class DashboardComponent extends BaseComponent implements OnInit {
  totalAssignDocumentCount = 0;
  expireSoonDocumentCount = 0
  constructor(private dashboardService: DashboradService) {
    super();
  }

  ngOnInit() {
  }
}


