import { Injectable } from '@angular/core';
import { HttpClient, HttpParams, HttpResponse } from '@angular/common/http';
import { Observable } from 'rxjs';
import { DocumentByCategory } from '@core/domain-classes/document-by-category';
import { catchError } from 'rxjs/operators';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { CalenderReminderDto } from '@core/domain-classes/calender-reminder';
import { CommonOverViewChart } from './model/commonOverViewChart';

@Injectable({ providedIn: 'root' })
export class DashboradService {
  constructor(private httpClient: HttpClient,
    private commonHttpErrorService: CommonHttpErrorService) { }

  getDocumentByCategory(): Observable<DocumentByCategory[]> {
    const url = `Dashboard/GetDocumentByCategory`;
    return this.httpClient.get<DocumentByCategory[]>(url);
  }

  getDailyReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/dailyreminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getWeeklyReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/weeklyreminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getMonthlyReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/monthlyreminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getQuarterlyReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/quarterlyreminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getHalfYearlyReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/halfyearlyreminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getYearlyReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/yearlyreminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getOneTimeReminders(month: number | null, year: number | null): Observable<CalenderReminderDto[] | CommonError> {
    const url = `dashboard/onetimereminder/${month}/${year}`;
    return this.httpClient.get<CalenderReminderDto[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getCapaRequestOnTimeCapa(): Observable<number | CommonError> {
    const url = 'CapaRequest/OnTimeCapa';
    return this.httpClient
      .get<number>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getCapaRequestCapaClosureRate(): Observable<number | CommonError> {
    const url = 'CapaRequest/CapaClosureRate';
    return this.httpClient
      .get<number>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getAuditComplinceRate(): Observable<number | CommonError> {
    const url = 'Audit/AuditComplinceRate';
    return this.httpClient
      .get<number>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getNonConformanceRate(): Observable<number | CommonError> {
    const url = 'NonConformance/NcRate';
    return this.httpClient
      .get<number>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getAuditStatusOverview(
    FormDate?: Date,
    ToDate?: Date,
  ): Observable<HttpResponse<CommonOverViewChart[]> | CommonError> {
    const url = 'Audit/status-overview';
    const params = new HttpParams()
      .set('FromDate', FormDate ? FormDate.toISOString() : '')
      .set('ToDate', ToDate ? ToDate.toISOString() : '');
    return this.httpClient.get<CommonOverViewChart[]>(url, {
      params: params,
      observe: 'response',
    })
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getNonConformanceChart(
    FormDate?: Date,
    ToDate?: Date,
  ): Observable<HttpResponse<CommonOverViewChart[]> | CommonError> {
    const url = 'NonConformance/NonConformanceOverview';
    const params = new HttpParams()
      .set('FromDate', FormDate ? FormDate.toISOString() : '')
      .set('ToDate', ToDate ? ToDate.toISOString() : '');
    return this.httpClient.get<CommonOverViewChart[]>(url, {
      params: params,
      observe: 'response',
    })
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getCapaChart(
    FormDate?: Date,
    ToDate?: Date,
  ): Observable<HttpResponse<CommonOverViewChart[]> | CommonError> {
    const url = 'CapaRequest/CapaOverview';
    const params = new HttpParams()
      .set('FromDate', FormDate ? FormDate.toISOString() : '')
      .set('ToDate', ToDate ? ToDate.toISOString() : '');
    return this.httpClient.get<CommonOverViewChart[]>(url, {
      params: params,
      observe: 'response',
    })
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getAuditByDepartment(
    FormDate?: Date,
    ToDate?: Date,
  ): Observable<HttpResponse<CommonOverViewChart[]> | CommonError> {
    const url = 'Audit/audit-by-department';
    const params = new HttpParams()
      .set('FromDate', FormDate ? FormDate.toISOString() : '')
      .set('ToDate', ToDate ? ToDate.toISOString() : '');
    return this.httpClient.get<CommonOverViewChart[]>(url, {
      params: params,
      observe: 'response',
    })
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getNcSeverityChart(
    FormDate?: Date | null,
    ToDate?: Date | null,
  ): Observable<HttpResponse<CommonOverViewChart[]> | CommonError> {
    const url = 'NonConformance/NonConformanceBySeverity';
    const params = new HttpParams()
      .set('FromDate', FormDate ? FormDate.toISOString() : '')
      .set('ToDate', ToDate ? ToDate.toISOString() : '');
    return this.httpClient.get<CommonOverViewChart[]>(url, {
      params: params,
      observe: 'response',
    })
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
