import { Component, inject, OnInit, signal } from '@angular/core';
import { DashboradService } from '../dashboard.service';
import { BaseComponent } from '../../base.component';
import { TranslateModule } from '@ngx-translate/core';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';

@Component({
  selector: 'app-statistics',
  standalone: true,
  imports: [
    MatIconModule,
    TranslateModule,
    MatCardModule
  ],
  templateUrl: './statistics.component.html',
  styleUrl: './statistics.component.scss'
})
export class StatisticsComponent extends BaseComponent implements OnInit {
  dashboardService = inject(DashboradService);

  CapaRequestOnTimeCapa = signal<number>(0);
  CapaRequestCapaClosureRate = signal<number>(0);
  auditComplinceRate = signal<number>(0);
  nonConformanceRate = signal<number>(0);

  ngOnInit(): void {
    this.getCapaRequestOnTimeCapa();
    this.getCapaRequestCapaClosureRate();
    this.getAuditComplinceRate();
    this.getNonConformanceRate();
  }

  getCapaRequestOnTimeCapa() {
    this.sub$.sink = this.dashboardService.getCapaRequestOnTimeCapa().subscribe({
      next: (data) => {
        const response = data as number;
        if (response) {
          this.CapaRequestOnTimeCapa.set(response);
        }
      },
    });
  }

  getCapaRequestCapaClosureRate() {
    this.sub$.sink = this.dashboardService.getCapaRequestCapaClosureRate().subscribe({
      next: (data) => {
        const response = data as number;
        if (response) {
          this.CapaRequestCapaClosureRate.set(response);
        }
      },
    });
  }

  getAuditComplinceRate() {
    this.sub$.sink = this.dashboardService.getAuditComplinceRate().subscribe({
      next: (data) => {
        const response = data as number;
        if (response) {
          this.auditComplinceRate.set(response);
        }
      },
    });
  }

  getNonConformanceRate() {
    this.sub$.sink = this.dashboardService.getNonConformanceRate().subscribe({
      next: (data) => {
        const response = data as number;
        if (response) {
          this.nonConformanceRate.set(response);
        }
      },
    });
  }
}
