import { Component, OnInit, inject } from "@angular/core";
import { MatCardModule } from "@angular/material/card";
import { BaseComponent } from "../../base.component";
import { NonConformance } from "../model/non-conformance";
import { ActivatedRoute, RouterLink } from "@angular/router";
import { NonConformanceResponseComponent } from "../non-conformance-responses/manage-non-conformance-response/manage-non-conformance-response.component";
import { TextEditorComponent } from "@shared/text-editor/text-editor.component";
import { FormsModule } from "@angular/forms";
import { PageHelpTextComponent } from "@shared/page-help-text/page-help-text.component";
import { HasClaimDirective } from "@shared/has-claim.directive";
import { TranslateModule } from "@ngx-translate/core";
import { NgClass } from "@angular/common";
import { NonConformanceStatusPipe } from "../pipes/non-conformance-status.pipe";
import { NonConformanceSeverityPipe } from "../pipes/non-conformance-severity.pipe";
import { MatButtonModule } from "@angular/material/button";
import { MatIconModule } from "@angular/material/icon";

@Component({
  selector: 'app-non-conformance-response-details',
  imports: [
    MatCardModule,
    NonConformanceResponseComponent,
    MatIconModule,
    RouterLink,
    TextEditorComponent,
    FormsModule,
    PageHelpTextComponent,
    HasClaimDirective,
    TranslateModule,
    NgClass,
    NonConformanceStatusPipe,
    NonConformanceSeverityPipe,
    MatButtonModule
  ],
  templateUrl: './non-conformance-details.component.html',
  styleUrl: './non-conformance-details.component.scss'
})
export class NonConformanceDetailsComponent extends BaseComponent implements OnInit {
  nonConformance: NonConformance;
  route = inject(ActivatedRoute);

  ngOnInit(): void {
    this.sub$.sink = this.route.data.subscribe(params => {
      const nonConformance = params['nonConformanceDetail'];
      if (nonConformance) {
        this.nonConformance = nonConformance;
      }
    });
  }
}
