
import { inject, Injectable } from '@angular/core';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { Observable, catchError } from 'rxjs';
import { NonConformance } from '../model/non-conformance';
import { NonConformanceResource } from '../model/non-conformance-resource';
import { HttpClient, HttpParams, HttpResponse } from '@angular/common/http';

@Injectable({
  providedIn: 'root'
})
export class NonConformanceLogService {
  private httpClient = inject(HttpClient)
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getNonConformanceLog(
    resource: NonConformanceResource
  ): Observable<HttpResponse<NonConformance[]>> {
    const url = 'NonConformanceLog';
    const customParams = new HttpParams()
      .set('OrderBy', resource.orderBy)
      .set('PageSize', resource.pageSize)
      .set('Skip', resource.skip)
      .set('NCNumber', resource.ncNumber)
      .set('ReportedById', resource.reportedById)
      .set('Severity', resource.severity)
      .set('Status', resource.status)
      .set('DepartmentId', resource.departmentId)
      .set('AuditId', resource.auditId)
      .set('Title', resource.title)
      .set('LogStatus', resource.logStatus ?? '');
    return this.httpClient
      .get<NonConformance[]>(url, {
        params: customParams,
        observe: 'response',
      });

  }
}
