import { Component, Inject, inject, OnInit } from '@angular/core';
import { toObservable } from '@angular/core/rxjs-interop';
import { FormBuilder, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogModule, MatDialogRef } from '@angular/material/dialog';
import { NonConformanceResponseTypeStore } from '../store/non-conformance-response-type-store';
import { ActivatedRoute } from '@angular/router';
import { BaseComponent } from '../../../base.component';
import { NonConformanceResponseType } from '../../../non-conformance/model/non-conformance-response-type';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonModule } from '@angular/material/button';
import { TranslateModule } from '@ngx-translate/core';
import { MatCardModule } from '@angular/material/card';

@Component({
  selector: 'app-manage-non-conformance-response-type',
  imports: [
    MatDialogModule,
    ReactiveFormsModule,
    MatIconModule,
    MatButtonModule,
    TranslateModule,
    MatCardModule
  ],
  templateUrl: './manage-non-conformance-response-type.component.html',
  styleUrl: './manage-non-conformance-response-type.component.scss'
})
export class ManageNonConformanceResponseTypeComponent extends BaseComponent implements OnInit {
  nonConformanceResponseTypeForm!: FormGroup;
  dialogRef = inject(MatDialogRef<ManageNonConformanceResponseTypeComponent>);
  fb = inject(FormBuilder);
  nonConformanceResponseTypeStore = inject(NonConformanceResponseTypeStore);
  route = inject(ActivatedRoute);
  isEdit = false;

  constructor(
    @Inject(MAT_DIALOG_DATA) public nonConformanceResponseTypeDetails: NonConformanceResponseType,
  ) {
    super();
    this.subscribeIsAddorUpdate();
  }

  ngOnInit(): void {
    this.createNonConformanceResponseTypeForm();
    if (this.nonConformanceResponseTypeDetails) {
      this.isEdit = true;
      this.nonConformanceResponseTypeForm.patchValue(this.nonConformanceResponseTypeDetails)
    }
  }

  createNonConformanceResponseTypeForm() {
    this.nonConformanceResponseTypeForm = this.fb.group(
      {
        id: [''],
        name: ['', [Validators.required]],
        description: [''],
      }
    );
  }

  onSubmit() {
    if (!this.nonConformanceResponseTypeForm.valid) {
      this.nonConformanceResponseTypeForm.markAllAsTouched();
      return;
    }
    if (this.isEdit) {
      this.nonConformanceResponseTypeStore.updateNonConformanceResponseType(this.nonConformanceResponseTypeForm.getRawValue());
    } else {
      this.nonConformanceResponseTypeStore.addNonConformanceResponseType(this.nonConformanceResponseTypeForm.getRawValue());
    }
  }

  onNoClick(nonConformanceResponseType?: NonConformanceResponseType | null): void {
    this.dialogRef.close(nonConformanceResponseType);
  }

  subscribeIsAddorUpdate() {
    toObservable(this.nonConformanceResponseTypeStore.isAddUpdate).subscribe((flag) => {
      if (flag) {
        this.onNoClick(this.nonConformanceResponseTypeStore.nonConformanceResponseType());
      }
      this.nonConformanceResponseTypeStore.resetFlag();
    })
  }
}
