import { Component, inject } from '@angular/core';
import { FormControl, ReactiveFormsModule } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { TranslationService } from '@core/services/translation.service';
import { debounceTime, distinctUntilChanged } from 'rxjs';
import { NonConformanceResponseTypeStore } from '../store/non-conformance-response-type-store';
import { ManageNonConformanceResponseTypeComponent } from '../manage-non-conformance-response-type/manage-non-conformance-response-type.component';
import { NonConformanceResponseType } from '../../../non-conformance/model/non-conformance-response-type';
import { MatTableModule } from '@angular/material/table';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { TranslateModule } from '@ngx-translate/core';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';

@Component({
  selector: 'app-non-conformance-response-type-list',
  imports: [
    MatIconModule,
    ReactiveFormsModule,
    MatTableModule,
    PageHelpTextComponent,
    TranslateModule,
    HasClaimDirective,
    MatButtonModule,
    MatCardModule,
    NgClass
  ],
  templateUrl: './non-conformance-response-type-list.component.html',
  styleUrls: ['./non-conformance-response-type-list.component.scss']
})
export class NonConformanceResponseTypeListComponent {
  private dialog = inject(MatDialog);
  translationService = inject(TranslationService);
  commandDialogService = inject(CommonDialogService);
  displayedColumns: string[] = ['action', 'nonConformanceResponseTypeName', 'description'];
  displayedColumns1: string[] = ['action-search', 'nonConformanceResponseTypeName-search', 'description-search']
  nonConformanceResponseTypeStore = inject(NonConformanceResponseTypeStore);
  filterNonConformanceResponseTypeName: FormControl = new FormControl();

  ngOnInit(): void {
    this.nonConformanceResponseTypeNameChangeValue();
  }

  nonConformanceResponseTypeNameChangeValue() {
    this.filterNonConformanceResponseTypeName.valueChanges.pipe(
      debounceTime(500),
      distinctUntilChanged()
    ).subscribe((value: string) => {
      this.nonConformanceResponseTypeStore.setNameFilter(value);
    });
  }

  addNonConformanceResponseType() {
    this.dialog.open(ManageNonConformanceResponseTypeComponent, {
      width: '600px',
    })
  }

  updateNonConformanceResponseType(nonConformanceResponseType: NonConformanceResponseType) {
    this.dialog.open(ManageNonConformanceResponseTypeComponent, {
      width: '600px',
      data: Object.assign({}, nonConformanceResponseType)
    })
  }

  deleteNonConformanceResponseType(nonConformanceResponseTypeId: string) {
    this.commandDialogService.deleteConfirmtionDialog(this.translationService.getValue("ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS_NON_CONFORMANCE_RESPONSE_TYPE")).subscribe({
      next: (result: boolean) => {
        if (result) {
          this.nonConformanceResponseTypeStore.deleteNonConformanceResponseTypeById(nonConformanceResponseTypeId);
        }
      }
    });
  }

  refresh() {
    this.nonConformanceResponseTypeStore.loadNonConformanceResponseTypes();
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.nonConformanceResponseTypeStore.nonConformanceResponseTypes().indexOf(row);
  }
}
