import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { NonConformanceResponseType } from '../../non-conformance/model/non-conformance-response-type';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { catchError, Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class NonConformanceResponseTypeService {
  private httpClient = inject(HttpClient)
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getNonConformanceResponseType(): Observable<NonConformanceResponseType[]> {
    const url = 'NonConformanceResponseType';
    return this.httpClient
      .get<NonConformanceResponseType[]>(url);
  }

  addNonConformanceResponseType(nonConformance: NonConformanceResponseType): Observable<NonConformanceResponseType | CommonError> {
    const url = 'NonConformanceResponseType';
    return this.httpClient
      .post<NonConformanceResponseType>(url, nonConformance)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateNonConformanceResponseType(nonConformance: NonConformanceResponseType): Observable<NonConformanceResponseType | CommonError> {
    const url = `NonConformanceResponseType/${nonConformance.id}`;
    return this.httpClient
      .put<NonConformanceResponseType>(url, nonConformance)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteNonConformanceResponseType(nonConformanceId: string): Observable<void | CommonError> {
    const url = `NonConformanceResponseType/${nonConformanceId}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getNonConformanceResponseTypeById(nonConformanceId: string): Observable<NonConformanceResponseType | CommonError> {
    const url = `NonConformanceResponseType/${nonConformanceId}`;
    return this.httpClient
      .get<NonConformanceResponseType>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
