import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { NonConformanceResponse } from '../model/non-conformance-response';
import { Observable } from 'rxjs';
import { NonConformanceResponseService } from './non-conformance-response.service';
import { inject } from '@angular/core';

export const NonConformanceResponseResolver: ResolveFn<NonConformanceResponse | undefined> = (route: ActivatedRouteSnapshot) => {
  const nonConformanceResponseService = inject(NonConformanceResponseService);
  const id = route.paramMap.get('ncResponseId');
  if (id != null) {
    return nonConformanceResponseService.getNonConformanceResponseById(id) as Observable<NonConformanceResponse>;
  }
  return;
};
