import { inject, Injectable } from '@angular/core';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { Observable, catchError } from 'rxjs';
import { HttpClient } from '@angular/common/http';
import { NonConformanceResponse } from '../model/non-conformance-response';
import { NonConformanceResponseChunkStatus } from '../model/non-conformance-response-chunk-status';
import { NonConformanceResponseDocument } from '../model/non-conformance-response-document';


@Injectable({
  providedIn: 'root'
})
export class NonConformanceResponseService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  creatNonConformanceResponse(ncResponse: NonConformanceResponse): Observable<NonConformanceResponse | CommonError> {
    const url = 'NonConformanceResponse';
    return this.httpClient
      .post<NonConformanceResponse>(url, ncResponse)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateNonConformanceResponse(ncResponse: NonConformanceResponse): Observable<NonConformanceResponse | CommonError> {
    const url = `NonConformanceResponse/${ncResponse.id}`;
    return this.httpClient
      .put<NonConformanceResponse>(url, ncResponse)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteNonConformanceResponse(responseId: string): Observable<void | CommonError> {
    const url = `NonConformanceResponse/${responseId}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getNonConformanceResponseById(responseId: string): Observable<NonConformanceResponse | CommonError> {
    const url = `NonConformanceResponse/${responseId}`;
    return this.httpClient
      .get<NonConformanceResponse>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addFileAttachment(document: NonConformanceResponseDocument): Observable<NonConformanceResponseDocument | CommonError> {
    const url = 'NonConformanceResponse/Attachment';
    return this.httpClient
      .post<NonConformanceResponseDocument>(url, document)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  uploadChunkDocument(file: FormData): Observable<NonConformanceResponseChunkStatus | CommonError> {
    const url = 'NonConformanceResponse/Attachment/Chunk'
    return this.httpClient
      .post<NonConformanceResponseChunkStatus>(url, file)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  completeChunkDocument(nonConformanceRespAttachmentId: string, status: boolean): Observable<void | CommonError> {
    const url = 'NonConformanceResponse/chunk/uploadStatus';
    return this.httpClient
      .post<void>(url, { nonConformanceRespAttachmentId: nonConformanceRespAttachmentId, status: status })
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteResponseAttachment(attachmentId: string): Observable<void | CommonError> {
    const url = `NonConformanceResponse/Attachment/${attachmentId}`;
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
