import { Routes } from "@angular/router";
import { AuthGuard } from "@core/security/auth.guard";
import { NonConformanceResolver } from "./non-conformance.resolver";
import { NonConformanceResponseResolver } from "./non-conformance-responses/non-conformance-response.resolver";

export const NON_CONFORMANCE_ROUTES: Routes = [
  {
    path: 'conformances',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_NON_CONFORMANCE' },
    loadComponent: () =>
      import(
        './non-conformance-list/non-conformance-list.component'
      ).then((c) => c.NonConformanceListComponent),
  },
  {
    path: 'conformance/manage',
    canMatch: [AuthGuard],
    data: { claimType: 'ADD_NON_CONFORMANCE' },
    loadComponent: () =>
      import(
        './manage-non-conformance/manage-non-conformance.component'
      ).then((c) => c.ManageNonConformanceComponent),
  },
  {
    path: 'conformance/manage/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'EDIT_NON_CONFORMANCE' },
    loadComponent: () =>
      import(
        './manage-non-conformance/manage-non-conformance.component'
      ).then((c) => c.ManageNonConformanceComponent),
    resolve: {
      nonConformanceDetail: NonConformanceResolver,
    },
  },
  {
    path: 'conformance/response/type/manage',
    canMatch: [AuthGuard],
    data: {
      claimType: [
        'ADD_NON_CONFORMANCE_RESPONSE_TYPE',
        'EDIT_NON_CONFORMANCE_RESPONSE_TYPE',
      ],
    },
    loadComponent: () =>
      import(
        './non-conformance-response-type/manage-non-conformance-response-type/manage-non-conformance-response-type.component'
      ).then((c) => c.ManageNonConformanceResponseTypeComponent),
  },
  {
    path: 'conformance/response/type',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_NON_CONFORMANCE_RESPONSE_TYPE' },
    loadComponent: () =>
      import(
        './non-conformance-response-type/non-conformance-response-type-list/non-conformance-response-type-list.component'
      ).then((c) => c.NonConformanceResponseTypeListComponent),
  },
  {
    path: 'conformance/logs',
    canMatch: [AuthGuard],
    data: { claimType: 'MANAGE_NON_CONFORMANCE_LOGS' },
    loadComponent: () =>
      import(
        './non-conformance-log-list/non-conformance-log-list.component'
      ).then((c) => c.NonConformanceLogListComponent),
  },
  {
    path: 'conformance/details/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'DETAILS_NON_CONFORMANCE' },
    loadComponent: () =>
      import(
        './non-conformance-details/non-conformance-details.component'
      ).then((c) => c.NonConformanceDetailsComponent),
    resolve: {
      nonConformanceDetail: NonConformanceResolver,
    },
  },
  {
    path: 'conformance/:ncId/response/:ncResponseId',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_NON_CONFORMANCE_RESPONSE' },
    loadComponent: () =>
      import(
        './non-conformance-responses/manage-non-conformance-response/manage-non-conformance-response.component'
      ).then((c) => c.NonConformanceResponseComponent),
    resolve: {
      nonConformanceResponseDetail: NonConformanceResponseResolver,
    },
  },
  {
    path: 'conformance/:ncId/response',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_NON_CONFORMANCE_RESPONSE' },
    loadComponent: () =>
      import(
        './non-conformance-responses/manage-non-conformance-response/manage-non-conformance-response.component'
      ).then((c) => c.NonConformanceResponseComponent),
    resolve: {
      nonConformanceResponseDetail: NonConformanceResponseResolver,
    },
  },
];
