import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { NonConformance } from './model/non-conformance';
import { NonConformanceService } from './non-conformance.service';
import { Observable } from 'rxjs';
import { inject } from '@angular/core';

export const NonConformanceResolver: ResolveFn<NonConformance | undefined> = (route: ActivatedRouteSnapshot) => {
  const nonConformanceService = inject(NonConformanceService);
  const id = route.params['id']
  if (id != null) {
    return nonConformanceService.getNonConformanceById(id) as Observable<NonConformance>;
  } return;
};
