import { Pipe, PipeTransform } from '@angular/core';
import { NON_CONFORMANCE_LOG_STATUS } from '../model/non-conformance-log-status.enum';

@Pipe({
  name: 'NonConformanceLogStatus'
})
export class NonConformanceLogStatusPipe implements PipeTransform {

  transform(value: number, ...args: unknown[]): string {
    switch (value) {
      case NON_CONFORMANCE_LOG_STATUS.CREATED:
        return 'CREATED';
      case NON_CONFORMANCE_LOG_STATUS.UPDETED:
        return 'UPDETED';
      case NON_CONFORMANCE_LOG_STATUS.DELETED:
        return 'DELETED';
      default:
        return '';
    }
  }
}
