import { Pipe, PipeTransform } from '@angular/core';
import { NON_CONFORMANCE_SEVERITY } from '../model/non-conformance-severity-enum';

@Pipe({
  name: 'NonConformanceSeverity'
})
export class NonConformanceSeverityPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case NON_CONFORMANCE_SEVERITY.LOW:
        return 'LOW';
      case NON_CONFORMANCE_SEVERITY.MEDIUM:
        return 'MEDIUM';
      case NON_CONFORMANCE_SEVERITY.HIGH:
        return 'HIGH';
      case NON_CONFORMANCE_SEVERITY.CRITICAL:
        return 'CRITICAL';
      default:
        return '';
    }
  }
}
