import { Pipe, PipeTransform } from '@angular/core';
import { NON_CONFORMANCE_STATUS } from '../model/non-conformance-status-enum';


@Pipe({
  name: 'NonConformanceStatus'
})
export class NonConformanceStatusPipe implements PipeTransform {

  transform(value: number, ...args: unknown[]): string {
    switch (value) {
      case NON_CONFORMANCE_STATUS.OPEN:
        return 'OPEN';
      case NON_CONFORMANCE_STATUS.INPROGRESS:
        return 'INPROGRESS';
      case NON_CONFORMANCE_STATUS.CLOSED:
        return 'CLOSED';
      case NON_CONFORMANCE_STATUS.REJECTED:
        return 'REJECTED';
      default:
        return '';
    }
  }
}
