import { Pipe, PipeTransform } from '@angular/core';
import { RISK_MANAGEMENT_CONTROL_EFFECTIVENESS } from '../model/risk-control-effectiveness.enum';

@Pipe({
  name: 'RiskControlEffectiveness'
})
export class RiskControlEffectivenessPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case RISK_MANAGEMENT_CONTROL_EFFECTIVENESS.High:
        return 'HIGH';
      case RISK_MANAGEMENT_CONTROL_EFFECTIVENESS.Medium:
        return 'MEDIUM';
      case RISK_MANAGEMENT_CONTROL_EFFECTIVENESS.Low:
        return 'LOW';
      case RISK_MANAGEMENT_CONTROL_EFFECTIVENESS.Ineffective:
        return 'INEFFECTIVE';
      default:
        return '';
    }
  }
}
