import { Pipe, PipeTransform } from '@angular/core';
import { RISK_MANAGEMENT_CONTROL_STATUS } from '../model/risk-control-status.enum';

@Pipe({
  name: 'RiskControlStatus'
})

export class RiskControlStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case RISK_MANAGEMENT_CONTROL_STATUS.Open:
        return 'OPEN';
      case RISK_MANAGEMENT_CONTROL_STATUS.Closed:
        return 'CLOSED';
      case RISK_MANAGEMENT_CONTROL_STATUS.Monitoring:
        return 'MONITORING';
      case RISK_MANAGEMENT_CONTROL_STATUS.Escalated:
        return 'ESCALATED';
      case RISK_MANAGEMENT_CONTROL_STATUS.Reviewed:
        return 'REVIEWED';
      default:
        return '';
    }
  }
}

