import { Pipe, PipeTransform } from '@angular/core';
import { RISK_MANAGEMENT_CONTROL_TYPE } from '../model/risk-control-type.enum';

@Pipe({
  name: 'RiskControlType'
})
export class RiskControlTypePipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case RISK_MANAGEMENT_CONTROL_TYPE.Mitigation:
        return 'MITIGATION';
      case RISK_MANAGEMENT_CONTROL_TYPE.Avoidance:
        return 'AVOIDANCE';
      case RISK_MANAGEMENT_CONTROL_TYPE.Transfer:
        return 'TRANSFER';
      case RISK_MANAGEMENT_CONTROL_TYPE.Acceptance:
        return 'ACCEPTANCE';
      case RISK_MANAGEMENT_CONTROL_TYPE.Monitoring:
        return 'MONITORING';
      default:
        return '';
    }
  }
}
