import { Pipe, PipeTransform } from '@angular/core';
import { RISK_LEVEL } from '../model/risk-level.enum';

@Pipe({
  name: 'RiskLevel'
})
export class RiskLevalPipe implements PipeTransform {

  transform(value: string): string {
    switch (value) {
      case RISK_LEVEL.LOW:
        return 'Low';
      case RISK_LEVEL.MEDIUM:
        return 'Medium';
      case RISK_LEVEL.HIGH:
        return 'High';
      case RISK_LEVEL.CRITICAL:
        return 'Critical';
      case RISK_LEVEL.VERY_HIGH:
        return 'Very High';
      default:
        return '';
    }
  }
}
