import { Pipe, PipeTransform } from '@angular/core';
import { RISK_LOG_STATUS } from '../model/risk-log-status.enum';

@Pipe({
  name: 'RiskLogStatus'
})
export class RiskLogStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case RISK_LOG_STATUS.CREATED:
        return 'CREATED';
      case RISK_LOG_STATUS.UPDATED:
        return 'UPDATED';
      case RISK_LOG_STATUS.DELETED:
        return 'DELETED';
      default:
        return '';
    }
  }
}
