import { Component, inject, OnInit } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MatTableModule } from '@angular/material/table';
import { ManageRiskManagementCategoryComponent } from '../manage-risk-category/manage-risk-category.component';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { BaseComponent } from '../../../base.component';
import { RiskManagementCategory } from '../../model/risk-category';

import { ToastrService } from '@core/services/toastr-service';
import { RiskManagementCategoryService } from '../risk-management-category.service';
import { MatButtonModule } from '@angular/material/button';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { TranslateModule } from '@ngx-translate/core';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';

@Component({
  selector: 'app-risk-management-category-list',
  imports: [
    MatTableModule,
    MatButtonModule,
    PageHelpTextComponent,
    HasClaimDirective,
    TranslateModule,
    MatIconModule,
    MatCardModule,
    NgClass
  ],
  templateUrl: './risk-management-category-list.component.html',
  styleUrl: './risk-management-category-list.component.scss'
})
export class RiskManagementCategoryListComponent extends BaseComponent implements OnInit {
  riskManagementCategorys: RiskManagementCategory[] = []
  dialog = inject(MatDialog);
  displayedColumns: string[] = ['action', 'name', 'description'];
  commandDialogService = inject(CommonDialogService);
  toastrService = inject(ToastrService);
  riskManagementCategoryService = inject(RiskManagementCategoryService);

  ngOnInit(): void {
    this.getAllRiskManagementCategorys();
  }

  getAllRiskManagementCategorys() {
    this.sub$.sink = this.riskManagementCategoryService.getRiskManagementCategory().subscribe({
      next: (data: RiskManagementCategory[]) => {
        this.riskManagementCategorys = [...data];
      },
    });
  }

  addRiskManagementCategory() {
    const dialogRef = this.dialog.open(ManageRiskManagementCategoryComponent, {
      width: '500px',
      data: null
    });
    this.sub$.sink = dialogRef.afterClosed().subscribe((result: RiskManagementCategory) => {
      if (result) {
        this.riskManagementCategorys = [result, ...this.riskManagementCategorys];
      }
    });
  }

  editRiskManagementCategory(category: RiskManagementCategory) {
    const dialogRef = this.dialog.open(ManageRiskManagementCategoryComponent, {
      width: '500px',
      data: category
    });
    this.sub$.sink = dialogRef.afterClosed().subscribe((result: RiskManagementCategory) => {
      if (result) {
        this.riskManagementCategorys = this.riskManagementCategorys.map(cat => cat.id === result.id ? { ...result } : cat);
      }
    });
  }

  deleteRiskManagementCategory(categoryId: string) {
    this.commandDialogService.deleteConfirmtionDialog(this.translationService.getValue("ARE_YOU_SURE_YOU_WANT_TO_DELETE_THIS_CATEGORY")).subscribe({
      next: (result: boolean) => {
        if (result) {
          this.sub$.sink = this.riskManagementCategoryService.deleteRiskManagementCategory(categoryId).subscribe({
            next: () => {
              this.toastrService.success(this.translationService.getValue("RISK_MANAGEMENT_CATEGORY_DELETED_SUCCESSFULLY"));
              this.riskManagementCategorys = this.riskManagementCategorys.filter(category => category.id !== categoryId);
            },
          });
        };
      }
    });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.riskManagementCategorys.indexOf(row);
  }
}
