import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { catchError, Observable } from 'rxjs';
import { RiskManagementCategory } from '../model/risk-category';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root'
})
export class RiskManagementCategoryService {
  private httpClient = inject(HttpClient)
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getRiskManagementCategory(): Observable<RiskManagementCategory[]> {
    const url = 'RiskCategory';
    return this.httpClient
      .get<RiskManagementCategory[]>(url);
  }

  addRiskManagementCategory(category: RiskManagementCategory): Observable<RiskManagementCategory | CommonError> {
    const url = 'RiskCategory';
    return this.httpClient
      .post<RiskManagementCategory>(url, category)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateRiskManagementCategory(category: RiskManagementCategory): Observable<RiskManagementCategory | CommonError> {
    const url = `RiskCategory/${category.id}`
    return this.httpClient
      .put<RiskManagementCategory>(url, category)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteRiskManagementCategory(categoryId: string): Observable<void | CommonError> {
    const url = `RiskCategory/${categoryId}`
    return this.httpClient
      .delete<void>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
